﻿namespace Microsoft.Samples.PlanMyNight.Web.Tests
{
    using System.Web;
    using System.Web.Mvc;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight.Entities;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Moq;

    [TestClass()]
    public class ViewModelExtensionsFixture
    {
        public static void PrepareControllerMock(Controller controller)
        {
            var controllerContext = new Mock<ControllerContext>();
            var requestContext = new Mock<RequestContext>();
            var routes = new RouteCollection();
            var response = new Mock<HttpResponseBase>();
            var request = new Mock<HttpRequestBase>();
            var httpContext = new Mock<HttpContextBase>();

            controllerContext.CallBase = true;

            requestContext.Setup(r => r.RouteData).Returns(new RouteData());
            requestContext.Setup(r => r.HttpContext).Returns(httpContext.Object);

            httpContext.Setup(h => h.Response).Returns(response.Object);
            httpContext.Setup(h => h.Request).Returns(request.Object);

            controllerContext.Object.RequestContext = requestContext.Object;

            RoutingManager.RegisterRoutes(routes);

            response.Setup(r => r.ApplyAppPathModifier(It.IsAny<string>())).Returns(string.Empty);

            controller.Url = new UrlHelper(requestContext.Object, routes);
            controller.ControllerContext = controllerContext.Object;
        }
        
        [TestMethod()]
        public void ShouldTranslateItineraryToViewModel()
        {
            var controller = new Mock<Controller>();

            PrepareControllerMock(controller.Object);

            var activity = new ItineraryActivity
             {
                 Activity = new Activity { Id = "1", Name = "RestoBar", PhoneNumber = "555-5555", City = "New York", State = "NY", Street = "Address 123", Zip = "1234", BingId = "1234" },
                 EstimatedMinutes = 10
             };

            var model = ViewModelExtensions.ToViewModel(controller.Object, activity);

            Assert.AreEqual(activity.Activity, model.Entity);
            Assert.AreEqual(activity.EstimatedMinutes, model.EstimatedMinutes);
        }
    }
}
